/*
	File:		DialogWindow.h

	Contains:	Dialog example showing Appearance Manager primitives.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#ifndef _DIALOGWINDOW_H
#define _DIALOGWINDOW_H

#include "Appearance.h"
#include "BaseWindow.h"

class DialogWindow : public BaseWindow
{
	public:
			DialogWindow();
		virtual ~DialogWindow();
		
		virtual void		Activate( EventRecord& event );
		virtual void		Deactivate( EventRecord& event );
		virtual void		Draw();
	
	private:
		void				DrawFakeEditText( ThemeDrawState state );
		void				DrawFakeListBox( ThemeDrawState state );
		void				DrawGroups( ThemeDrawState state );
		void				DrawSeparators( ThemeDrawState state );

};

#endif // _DIALOGWINDOW_H
